<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Entities\Repository\NestedTreeRepository;
use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Entities;
use EshopCatalog\Model\Entities\Category;
use EshopCatalog\FrontModule\Model\Categories as FrontCategories;
use Nette\Caching\Cache;

/**
 * Class Categories
 * @package EshopCatalog\AdminModule\Model
 *
 * @method Category|object|null getReference($id)
 * @method Category[]|null getAll()
 * @method NestedTreeRepository getEr()
 */
class Categories extends BaseEntityService
{
	use TPublish;

	protected $entityClass = Category::class;

	/** @var CacheService */
	protected $cacheService;

	public function __construct(CacheService $cacheService)
	{
		$this->cacheService = $cacheService;
	}

	public function get($id): ?Category
	{
		return $this->getEr()->createQueryBuilder('c')->addSelect('ct')
			->leftJoin('c.categoryTexts', 'ct')
			->where('c.id = :id')->setParameter('id', $id)
			->getQuery()->getOneOrNullResult();
	}

	/**
	 * @param $id
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function removeCategory($id)
	{
		try {
			if ($category = $this->getEr()->find($id)) {
				$ct = $this->em->getRepository(Entities\CategoryTexts::class)->findBy(['id' => $id, 'lang' => 'cs']);
				$this->em->remove($ct);
				$this->em->flush();
				$this->em->remove($category);
				$this->em->flush();

				return true;
			}
		} catch (\Exception $e) {
		}

		return false;
	}

	public function cleanCacheDeep($categoryId)
	{
		$cat = $this->get($categoryId);

		if (!$cat)
			return false;

		$tags = ['category/' . $cat->getId(), 'hierarchy'];
		$loop = function($childs) use (&$loop, &$ids) {
			foreach ($childs as $child) {
				$tags[] = 'category/' . $child->getId();

				if ($child->children->toArray())
					$loop($child->children->toArray());
			}
		};

		$loop($cat->children->toArray());

		$this->cacheService->categoryCache->clean([Cache::TAGS => $tags]);
	}
}
