<?php declare(strict_types = 1);

namespace EshopCatalog\CronModule\Presenters;

use EshopCatalog\FrontModule\Model\ExportFacade;
use Nette\Application\Responses\TextResponse;

class ExportPresenter extends BasePresenter
{
	/** @var ExportFacade */
	protected $exportFacade;

	protected $fileHandles = [];

	public function __construct(ExportFacade $exportFacade)
	{
		$this->exportFacade = $exportFacade;
	}

	/*******************************************************************************************************************
	 * ============================== Actions
	 */

	public function actionPorovnavace()
	{
		$types = $this->getHttpRequest()->getQuery('type');
		if ($types) {
			set_time_limit(600);

			$this->exportFacade->generateExport($types);
			$msg = 'ok';
		} else {
			$msg = 'error';
		}

		$response = new TextResponse($msg);
		$this->sendResponse($response);
	}
}
