<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * Class ProductVariantCombination
 * @package EshopCatalog\Model\Entities
 *
 * @ORM\Table(name="eshop_catalog__product_variant_combination")
 * @ORM\Entity
 * @ORM\EntityListeners({"ProductVariantCombinationListener"})
 */
class ProductVariantCombination
{
	use MagicAccessors;

	/**
	 * @var ProductVariant
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="ProductVariant", cascade={"persist"})
	 * @ORM\JoinColumn(name="id_product_variant", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $productVariant;

	/**
	 * @var VariantValue
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="VariantValue", cascade={"persist"})
	 * @ORM\JoinColumn(name="id_variant_value", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $value;

	/**
	 * @var Variant
	 * @ORM\ManyToOne(targetEntity="Variant")
	 * @ORM\JoinColumn(name="id_variant", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $variant;

	/**
	 * ProductVariantCombination constructor.
	 *
	 * @param ProductVariant $productVariant
	 * @param VariantValue   $variantValue
	 * @param Variant        $variant
	 */
	public function __construct(ProductVariant $productVariant, VariantValue $variantValue, Variant $variant)
	{
		$this->productVariant = $productVariant;
		$this->value          = $variantValue;
		$this->variant        = $variant;
	}

	/**
	 * @return int
	 */
	public function getIdValue() { return $this->value->getId(); }

	/**
	 * @return mixed
	 */
	public function getIdVariant() { return $this->variant->getId(); }

	/**
	 * @return VariantValue
	 */
	public function getValue() { return $this->value; }

	/**
	 * @return Variant
	 */
	public function getVariant() { return $this->variant; }
}
