<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Features;

use Core\Components\Flashes\Flashes;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use EshopCatalog\Model\Entities\Feature;
use EshopCatalog\Model\Entities\FeatureTexts;
use EshopCatalog\AdminModule\Model\Features;

class FeatureForm extends BaseControl
{
	/** @var Feature */
	public $feature;

	/** @var FeatureTexts */
	public $featureTexts;

	/** @var \EshopCatalog\AdminModule\Model\Features */
	protected $featureServices;

	public function __construct(Features $features)
	{
		$this->featureServices = $features;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addText('name', 'eshopCatalog.featureForm.name')->setIsMultilanguage()
			->setMaxLength(255)->setRequired();
		$form->addBool('isPublished', 'eshopCatalog.featureForm.isPublished')->setDefaultValue(1);
		$form->addBool('useAsFilter', 'eshopCatalog.featureForm.useAsFilter')->setDefaultValue(1);

		$form->addSaveCancelControl('saveControl');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			$feature = $this->feature ?: new Feature();

			$feature->isPublished = $values->isPublished;
			$feature->useAsFilter = $values->useAsFilter;

			$mTexts = $form->prepareMultilangTextsForEntity(['name'], $values);
			foreach ($mTexts as $lang => $vals) {
				$featureText = $feature->getFeatureText($lang) ?: new FeatureTexts($feature, $lang);
				foreach ($vals as $k => $v)
					$featureText->$k = $v;

				$this->em->persist($featureText);
			}

			$this->em->persist($feature);
			$this->em->flush();
			$form->addCustomData('featureId', $feature->getId());
			$this->getPresenter()->flashMessageSuccess('eshopCatalog.featureForm.featureSaved', Flashes::FLASH_SUCCESS);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setFeature($id)
	{
		$this->feature = $this->featureServices->get($id);

		if ($this->feature) {
			$form = $this['form'];
			$form->setDefaults([
				'isPublished' => $this->feature->isPublished,
				'useAsFilter' => $this->feature->useAsFilter,
			]);

			$mTexts = $form->prepareMultilangTextsForForm(['name'], $this->feature->getFeatureTexts()->toArray());
			$form->setDefaults($mTexts['texts']);
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}

