<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Features;

use Core\Components\Flashes\Flashes;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use EshopCatalog\Model\Entities\Feature;
use EshopCatalog\Model\Entities\FeatureTexts;
use EshopCatalog\AdminModule\Model\Features;
use EshopCatalog\Model\Entities\FeatureValue;
use EshopCatalog\Model\Entities\FeatureValueTexts;
use EshopCatalog\AdminModule\Model\FeatureValues;

class FeatureValueForm extends BaseControl
{
	/** @var featureValue */
	public $featureValue;
	
	/** @var featureValueTexts */
	public $featureValueTexts;

	/** @var FeatureValues */
	protected $featureValueServices;
	
	public function __construct(FeatureValues $featureValues)
	{
		$this->featureValueServices = $featureValues;
	}
	
	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}
	
	protected function createComponentForm()
	{
		$form = $this->createForm();
		
		$features = [null => ''];
		foreach ($this->em->getRepository(Feature::class)->createQueryBuilder('f')->select('f.id, ft.name')
				->leftJoin(FeatureTexts::class, 'ft', 'WITH', 'f.id = ft.id')
				->where('ft.lang = :lang')->setParameter('lang', 'cs')->getQuery()->getResult() as $g) {
			/** @var Featury $g */
			$features[$g['id']] = $g['name'];
		}
		
		if(count($features) == 1){
			return $form;
		}
				
		$form->addSelect('feature', 'eshopCatalog.featureValueForm.feature', $features)->setRequired();
		$form->addText('value', 'eshopCatalog.featureValueForm.value')->setRequired()->setMaxLength(255);
		$form->addSubmit('saveAndNew', NULL ?: 'eshopCatalog.defaultForm.saveAndNew')->getControlPrototype()->addHtml('<i class="fa fa-save"></i>');
		$form->addSaveCancelControl('saveControl');
		
		
		
		//editace 
		if ($this->featureValue) {
			$form->setDefaults([
				'value' => $this->featureValueTexts->name,
				'feature' => $this->featureValue->feature->getId()
			]);
		}
		
		$form->onSuccess[] = [$this, 'formSuccess'];
		
		return $form;
	}
	
	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			$featureValue = $this->featureValue ? : new FeatureValue();
			
			if(isset($this->featureValue))
				$featureValue->setFeatureValueText($this->featureValueTexts);
			else
				$featureValue->addFeatureValueText('cs');
			$featureValue->getFeatureValueText('cs')->name = $values->value;
			$feature = $this->em->getRepository(Feature::class)->find($values->feature);
			$featureValue->setFeature($feature);
			
			$this->em->persist($featureValue);
			$this->em->flush();
			$form->addCustomData('featureValueId', $featureValue->getId());
			$this->getPresenter()->flashMessageSuccess('eshopCatalog.featureValueForm.featureValueSaved', Flashes::FLASH_SUCCESS);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());
			return false;
		}
	}
	
	public function setFeatureValue($id)
	{
		$this->featureValue = $this->em->getRepository(FeatureValue::class)->find($id);
		$this->featureValueTexts = $this->em->getRepository(FeatureValueTexts::class)->findOneBy(array('id' => $id, 'lang' => 'cs'));

		if (!$this->featureValue)
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}

