<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\SpecificPrices;

use Core\Components\Flashes\Flashes;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\AdminModule\Model\Categories;
use EshopCatalog\AdminModule\Model\SpecificPrices;
use EshopCatalog\Model\Entities\SpecificPriceRule;
use EshopOrders\AdminModule\Model\GroupsCustomers;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;

/**
 * Class SpecificPriceForm
 * @package EshopCatalog\AdminModule\Components\SpecificPrices
 */
class SpecificPriceForm extends BaseControl
{
	/** @var SpecificPriceRule */
	public $specificPrice;

	/** @var SpecificPrices */
	protected $specificPriceServices;

	/** @var GroupsCustomers */
	protected $groupCustomersServices;

	/** @var Categories */
	protected $categoriesService;

	public function __construct(SpecificPrices $specificPrices, GroupsCustomers $groupsCustomers, Categories $categories)
	{
		$this->specificPriceServices  = $specificPrices;
		$this->groupCustomersServices = $groupsCustomers;
		$this->categoriesService      = $categories;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addText('name', 'eshopCatalog.specificPriceForm.name')->setRequired()->setMaxLength(255);
		$form->addBool('isPublished', 'eshopCatalog.specificPriceForm.isPublished')->setDefaultValue(0);
		$groups         = [0 => 'eshopCatalog.specificPriceForm.allGroups'];
		$groupCustomers = $this->groupCustomersServices->getAll();
		foreach ($groupCustomers as $gc)
			$groups[$gc->getId()] = $gc->name;
		$form->addSelect('group', 'eshopCatalog.specificPriceForm.group', $groups);
		$form->addSelect('category', $this->t('eshopCatalog.specificPriceForm.category'),
			[0 => 'eshopCatalog.specificPriceForm.allCategories'] + $this->categoriesService->forSelectInput())
			->setTranslator(null);
		$form->addInteger('fromQuantity', 'eshopCatalog.specificPriceForm.fromQuantity')->setDefaultValue(1);
		$typReduction = [
			0 => $this->translator->translate('eshopCatalog.specificPriceForm.price'),
			1 => $this->translator->translate('eshopCatalog.specificPriceForm.percentage'),
		];
		$form->addRadioList('percentage', 'eshopCatalog.specificPriceForm.typReduction', $typReduction);
		$form->addInteger('value', 'eshopCatalog.specificPriceForm.value')->setRequired();
		$form->addDatePicker('from', 'eshopCatalog.specificPriceForm.from');
		$form->addDatePicker('to', 'eshopCatalog.specificPriceForm.to');

		$form->addSaveCancelControl('saveControl');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			$specificPrice = $this->specificPrice ?: new SpecificPriceRule();

			$specificPrice->name         = $values->name;
			$specificPrice->isPublished  = $values->isPublished;
			$specificPrice->groupId      = $values->group;
			$specificPrice->categoryId   = $values->category;
			$specificPrice->fromQuantity = $values->fromQuantity;
			$specificPrice->fromDate     = $values->from;
			$specificPrice->toDate       = $values->to;
			$specificPrice->isPercentage = $values->percentage;
			$specificPrice->reduction    = $values->value;
			$specificPrice->vatRateId    = null;

			$this->em->persist($specificPrice);
			$this->em->flush();
			$form->addCustomData('specificPriceId', $specificPrice->getId());
			$this->getPresenter()->flashMessageSuccess('eshopCatalog.specificPriceForm.specificPriceSaved');
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setSpecificPrice($id)
	{
		$this->specificPrice = $this->em->getRepository(SpecificPriceRule::class)->find($id);

		if ($this->specificPrice) {
			$form = $this['form'];
			$form->setDefaults([
				'name'         => $this->specificPrice->name,
				'isPublished'  => $this->specificPrice->isPublished,
				'group'        => $this->specificPrice->groupId,
				'category'     => $this->specificPrice->categoryId,
				'fromQuantity' => $this->specificPrice->fromQuantity,
				'from'         => $this->specificPrice->fromDate,
				'to'           => $this->specificPrice->toDate,
				'percentage'   => $this->specificPrice->isPercentage,
				'value'        => $this->specificPrice->reduction,
			]);
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
