<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Tags;

use Core\Components\Flashes\Flashes;
use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\Model\Entities\Tag;
use EshopCatalog\Model\Entities\TagText;
use Nette\Http\IResponse;
use Nette\Utils\ArrayHash;
use EshopCatalog\AdminModule\Model\Tags;

class TagForm extends BaseControl
{
	/** @var Tag */
	public $tag;

	/** @var \EshopCatalog\AdminModule\Model\Tags */
	protected $tagServices;

	public function __construct(Tags $tags)
	{
		$this->tagServices = $tags;
	}

	public function render()
	{
		$this->template->render($this->getTemplateFile());
	}

	protected function createComponentForm()
	{
		$form = $this->createForm();

		$form->addText('type', 'eshopCatalog.tagForm.type')->setRequired()->setMaxLength(255);
		$form->addText('name', 'eshopCatalog.tagForm.name')->setRequired()
			->setIsMultilanguage()->setMaxLength(255);
		$form->addFilesManager('image', 'default.image');

		$form->addSaveCancelControl('saveControl');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	public function formSuccess(BaseForm $form, ArrayHash $values)
	{
		try {
			$tag = $this->tag ?: new Tag();

			$tag->type  = $values->type;
			$tag->image = $values->image;

			$langs      = [];
			$langInputs = ['name'];
			foreach ($langInputs as $name)
				foreach ($values->$name as $l => $v)
					if ($v != '')
						$langs[$l] = $l;

			foreach ($langs as $l) {
				$texts = $tag->getText($l);

				if (!$texts)
					$texts = new TagText($tag, $l);

				foreach ($langInputs as $name)
					$texts->$name = $values->$name[$l];
				$this->em->persist($texts);
			}

			$this->em->persist($tag);
			$this->em->flush();
			$form->addCustomData('tagType', $tag->type);
			$this->getPresenter()->flashMessageSuccess('eshopCatalog.tagForm.tagSaved', Flashes::FLASH_SUCCESS);
		} catch (\Exception $e) {
			$form->addError($e->getMessage());

			return false;
		}
	}

	public function setTag($type)
	{
		$this->tag = $this->em->getRepository(Tag::class)->findOneBy(['type' => $type]);

		if ($this->tag) {
			$form     = $this['form'];
			$defaults = [
				'type'  => $this->tag->type,
				'image' => $this->tag->image,
			];

			foreach ($this->langsService->getLangs(false) as $lang) {
				foreach (['name'] as $name) {
					$defaults[$name][$lang->getTag()] = $this->tag->getText($lang->getTag())->$name;
				}
			}

			$form->setDefaults($defaults);
		} else
			$this->getPresenter()->error(null, IResponse::S404_NOT_FOUND);
	}
}
