<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPosition;
use Core\Model\Helpers\Traits\TPublish;
use function Couchbase\basicDecoderV1;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Entities\Category;
use EshopCatalog\Model\Entities\SpecificPriceRule;
use Nette\Caching\Cache;

/**
 * Class SpecificPrices
 * @package EshopCatalog\AdminModule\Model
 */
class SpecificPrices extends BaseEntityService
{
	use TPublish;
	use TPosition;

	protected $entityClass = SpecificPriceRule::class;

	/** @var SpecificPriceRule[] */
	protected $cRules = [];

	/** @var CacheService */
	protected $cacheService;

	public function __construct(CacheService $cacheService)
	{
		$this->cacheService = $cacheService;
	}

	/**
	 * @param      $price
	 * @param      $categoryIds
	 * @param null $customerId
	 * @param int  $cartCountProduct
	 *
	 * @return bool
	 *
	 * Funkce vraci stav jestli se uplatnila sleva
	 */
	public function getPrice(&$price, $categoryIds, $customerId = null, $cartCountProduct = 1)
	{
		$ids = [];
		foreach ($categoryIds as $id) {
			$ids[$id] = $id;
			$this->getIdParent($id, $ids);
		}

		$reduction    = 0;
		$isPercentage = false;
		foreach ($this->findRule($ids) as $entity) {
			$now = new \DateTime();
			if (isset($entity->fromDate) && $entity->fromDate < $now)
				if (isset($entity->toDate) && $entity->toDate > $now) {

				}
			$this->changedPrice($price, $entity);

			return true;
		}

		return false;
	}

	private function changedPrice(&$price, SpecificPriceRule $sp)
	{
		if ($sp->isPercentage)
			$price = $price - ($price * $sp->reduction / 100);
		else
			$price = $price - $sp->reduction;
	}

	private function getIdParent($categoryId, &$ids)
	{
		/** @var  Category */
		$category = $this->em->getReference(Category::class, $categoryId);
		$parent   = $category->parent;
		if ($parent) {
			$ids[$parent->getId()] = $parent->getId();
			$this->getIdParent($parent->getId(), $ids);
		}
	}

	/**
	 * @param mixed $categoryIds
	 *
	 * @return SpecificPriceRule
	 */
	protected function findRule($categoryIds)
	{
		$key = md5(serialize($categoryIds));
		if (!isset($this->cRules[$key]))
			$this->cRules[$key] = $this->getEr()->findBy(['categoryId' => $categoryIds, 'isPublished' => 1]);

		return $this->cRules[$key];
	}
}
