<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Presenters;

use Core\Components\Flashes\Flashes;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\AdminModule\Components\SpecificPrices\ISpecificPriceFormFactory;
use EshopCatalog\AdminModule\Components\SpecificPrices\ISpecificPricesGridFactory;
use EshopCatalog\Model\Entities\SpecificPriceRule;

/**
 * Class SpecificPricePresenter
 * @package EshopCatalog\AdminModule\Presenters
 */
class SpecificPricesPresenter extends BasePresenter
{
	/*******************************************************************************************************************
	 * ==================================   Actions
	 */

	public function actionDefault()
	{
		$this->setTitle($this->translator->translate('eshopCatalog.title.specificPrices'));
		$this->setHeader('eshopCatalog.title.specificPrices', 'fa fa-list');

		$this['navigation']->setData(['header' => [
			[
				'title' => 'eshopCatalog.menu.addSpecificPrice',
				'link'  => 'SpecificPrices:add',
				'ico'   => 'plus',
			],
		]]);
	}

	public function actionAdd()
	{
		$this->setTitle($this->translator->translate('eshopCatalog.title.newSpecificPrice'));
		$this->setHeader('eshopCatalog.title.newSpecificPrice', 'fa fa-list-alt');
	}

	public function actionEdit($id)
	{
		$specificPrice = $this->em->getRepository(SpecificPriceRule::class)->find($id);

		if (!$specificPrice)
			$this->error(null, IResponse::S404_NOT_FOUND);

		$this->setTitle($this->translator->translate('eshopCatalog.title.editSpecificPrice'));
		$this->setHeader('eshopCatalog.title.editSpecificPrice', 'fa fa-list-alt');
	}

	/*******************************************************************************************************************
	 * ==================================   Components
	 */

	protected function createComponentSpecificPricesGrid(ISpecificPricesGridFactory $factory)
	{
		return $factory->create();
	}

	protected function createComponentSpecificPriceForm(ISpecificPriceFormFactory $specificPrice)
	{
		$control = $specificPrice->create();
		if ($this->getParameter('id'))
			$control->setSpecificPrice($this->getParameter('id'));

		$control['form']->onSuccessSave[]         = function(BaseForm $form) {
			$this->redirect('SpecificPrices:edit', $form->getCustomData('specificPriceId'));
		};
		$control['form']->onSuccessSaveAndClose[] = function(BaseForm $form) {
			$this->redirect('SpecificPrices:default');
		};
		$control['form']->onCancel[]              = function(BaseForm $form) {
			$this->redirect('SpecificPrices:default');
		};

		return $control;
	}

}
