<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use Core\Model\Entities\TSeo;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;

/**
 * TODO zkusit z parent a child udělat funkce
 *
 * Class Category
 * @package EshopCatalog\FrontModule\Model\Dao
 */
class Category
{
	use MagicAccessors;
	use TSeo;

	/** @var int */
	public $id;

	/** @var string */
	public $name;

	/** @var string */
	public $nameH1;

	/** @var string */
	public $alias;

	/** @var string */
	public $shortDescription;

	/** @var string */
	public $description;

	/** @var string */
	public $image;

	/** @var int */
	public $lvl;

	/** @var array */
	protected $childrenId = [];

	/** @var self[] */
	protected $children = [];

	/** @var int */
	protected $parentId;

	/** @var self */
	protected $parent;

	/** @var string */
	public $link = '#';

	/** @var DateTime */
	protected $created;

	/** @var DateTime */
	protected $modified;

	/** @var int */
	protected $filtersFromParent;

	/**
	 * @return Category
	 */
	public function getParent() { return $this->parent; }

	/**
	 * @return int
	 */
	public function getParentId() { return $this->parentId; }

	/**
	 * @param int $id
	 *
	 * @return $this
	 */
	public function addChildrenId($id)
	{
		$this->childrenId[$id] = $id;

		return $this;
	}

	/**
	 * @return int[]
	 */
	public function getChildrenId() { return $this->childrenId; }

	/**
	 * @param Category $category
	 *
	 * @return $this
	 */
	public function addChildren($category)
	{
		$this->children[$category->id] = $category;

		return $this;
	}

	/**
	 * @return Category[]
	 */
	public function getChildren() { return $this->children ?: []; }
}
