<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use Core\Model\Entities\TSeo;
use EshopCatalog\Model\Entities\Manufacturer;
use Gallery\FrontModule\Model\Dao\Album;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;

class Product
{
	use MagicAccessors;
	use TSeo;

	/** @var int */
	private $id;

	/** @var int */
	public $quantity;

	/** @var float */
	public $price;

	/** @var float */
	public $retailPrice;
	
	/** @var int */
	protected $manufacturerId;
	
	/** @var Manufacturer */
	private $manufacturer;

	/** @var string */
	public $name;

	/** @var string */
	public $shortDescription;

	/** @var string */
	public $description;

	/** @var DateTime */
	public $created;

	/** @var DateTime */
	public $modified;

	/** @var int */
	protected $galleryId;

	/** @var Album */
	private $gallery;

	/** @var VariantsList[] */
	protected $variants;

	/** @var FeatureProduct[] */
	protected $features;

	/** @var self[] */
	protected $related;

	/** @var self[] */
	protected $alternative;

	/** @var int */
	public $defaultCategory;

	/** @var int[] */
	public $categories;

	/** @var Tag[] */
	public $tags;

	/** @var string */
	public $link = '#';
	
	/** @var string */
	protected $ean;
	
	/** @var string */
	protected $code1;

	public function __construct($id)
	{
		$this->id = $id;
	}

	/**
	 * @return int
	 */
	public function getId()
	{
		return $this->id;
	}

	/**
	 * @return int
	 */
	public function getQuantity()
	{
		return $this->quantity;
	}

	/**
	 * @param int $quantity
	 */
	public function setQuantity(int $quantity)
	{
		$this->quantity = $quantity;
	}

	/**
	 * @return float
	 */
	public function getPrice()
	{
		return $this->price;
	}

	/**
	 * @param float $price
	 */
	public function setPrice(float $price)
	{
		$this->price = $price;
	}

	/**
	 * @return float
	 */
	public function getRetailPrice()
	{
		return $this->retailPrice;
	}

	/**
	 * @param float $retailPrice
	 */
	public function setRetailPrice(float $retailPrice)
	{
		$this->retailPrice = $retailPrice;
	}
	
	/**
	 * @return Manufacturer
	 */
	public function getManufacturer()
	{
		return $this->manufacturer;
	}
	
	/**
	 * @param mixed $manufacturer
	 */
	public function setManufacturer($manufacturer)
	{
		$this->manufacturer = $manufacturer;
	}

	/**
	 * @return string
	 */
	public function getName()
	{
		return $this->name;
	}

	/**
	 * @param string $name
	 */
	public function setName($name)
	{
		$this->name = $name;
	}

	/**
	 * @return string
	 */
	public function getDescription()
	{
		return $this->description;
	}

	/**
	 * @param string $description
	 */
	public function setDescription($description)
	{
		$this->description = $description;
	}

	/**
	 * @return mixed
	 */
	public function getGallery()
	{
		return $this->gallery;
	}

	/**
	 * @param mixed $gallery
	 */
	public function setGallery($gallery)
	{
		$this->gallery = $gallery;
	}

	/**
	 * @return ProductVariant[]
	 */
	public function getVariants()
	{
		return $this->variants;
	}

	/**
	 * @param ProductVariant[] $variants
	 */
	public function setVariants($variants)
	{
		$this->variants = $variants;
	}

	/**
	 * @param FeatureProduct[] $features
	 */
	public function setFeatures($features)
	{
		$this->features = $features;
	}

	/**
	 * @return FeatureProduct[]
	 */
	public function getFeatures() { return $this->features; }

	/**
	 * @param string $type
	 *
	 * @return Tag|null
	 */
	public function getTag($type) { return $this->tags[$type] ?? null; }

	/**
	 * @param self[] $array
	 *
	 * @return $this
	 */
	public function setAlternatives($array)
	{
		$this->alternative = $array;

		return $this;
	}
	
	/** @return string */
	public function getEan()
	{
		return $this->ean;
	}
	
	/**
	 * @param string $ean
	 * @return Product
	 */
	public function setEan($ean): Product
	{
		$this->ean = $ean;
		return $this;
	}
	
	/**
	 * @return string
	 */
	public function getCode1()
	{
		return $this->code1;
	}
	
	/**
	 * @param $code1
	 * @return Product
	 */
	public function setCode1($code1): Product
	{
		$this->code1 = $code1;
		return $this;
	}
	
}
