<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use Kdyby\Events\Subscriber;
use Nette\Localization\ITranslator;
use Nette\Caching\Cache;
use Nette\SmartObject;

class CategoryTextListener implements Subscriber
{
	use SmartObject;

	/** @var CacheService */
	protected $cacheService;

	/** @var ITranslator */
	protected $translator;

	public function __construct(ITranslator $translator, CacheService $cacheService)
	{
		$this->cacheService = $cacheService;
		$this->translator   = $translator;
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param CategoryTexts      $categoryText
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($categoryText, $args)
	{
		if ($categoryText->getCategory()->getId()) {
			$this->cacheService->clean('category', [
				Cache::TAGS => ['category/' . $categoryText->getCategory()->getId()],
			]);
		} else {
			$this->cacheService->clean('category', [
				Cache::TAGS => ['categories'],
			]);
		}
		$this->cacheService->clean('category', [
			Cache::TAGS => ['hierarchy'],
		]);

		$this->cacheService->clean('default', [
			Cache::TAGS => ['categories', 'category/' . $categoryText->getCategory()->getId()],
		]);

		$this->cacheService->clean('navigation', [
			Cache::TAGS => [
				'category/' . $categoryText->getCategory()->getId(),
				'EshopCatalog:Front:Default:category/' . $categoryText->getCategory()->getId(),
			],
		]);
	}
}
