<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TSeo;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Core\Model\Entities\TLang;
use Nette\Utils\Strings;

/**
 * @ORM\Table(name="eshop_catalog__category_texts")
 * @ORM\Entity
 * @ORM\EntityListeners({"CategoryTextListener"})
 */
class CategoryTexts
{
	use MagicAccessors;
	use TSeo;

	/**
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Category", inversedBy="categoryTexts", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="id", referencedColumnName="id", onDelete="CASCADE")
	 * )
	 */
	private $id;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2)
	 */
	private $lang;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=255)
	 */
	protected $name;

	/**
	 * @var string
	 * @ORM\Column(name="name_h1", type="string", length=255, nullable=true)
	 */
	protected $nameH1;

	/**
	 * @var string
	 * @ORM\Column(name="alias", type="string", length=255)
	 */
	protected $alias;

	/**
	 * @var string
	 * @ORM\Column(name="description", type="text", nullable=true)
	 */
	public $description;

	public function __construct($id, $lang)
	{
		$this->id   = $id;
		$this->lang = $lang;
		$this->seo  = [];
	}

	/**
	 * @param string $name
	 *
	 * @return self
	 */
	public function setName($name)
	{
		$this->name = $name;
		if (!$this->alias)
			$this->alias = Strings::webalize($name);

		return $this;
	}

	/** @return string */
	public function getName() { return $this->name;}

	public function setAlias($alias)
	{
		$this->alias = $alias && $alias != '' ? $alias : Strings::webalize($this->name);
	}

	public function getCategory() { return $this->id; }

	public function getLang()
	{
		return $this->lang;
	}

	public function getNameH1()
	{
		return $this->nameH1 ?: $this->name;
	}
	
}

