<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\Common\Collections\ArrayCollection;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="eshop_catalog__feature")
 * @ORM\Entity
 * @ORM\EntityListeners({"FeatureListener"})
 */
class Feature
{

	use Identifier;
	use MagicAccessors;

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	protected $position;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", length=1, options={"default":1})
	 */
	protected $isPublished;

	/**
	 * @var int
	 * @ORM\Column(name="use_filter", type="smallint", length=1, options={"default":0})
	 */
	protected $useAsFilter;

	/**
	 * @var FeatureTexts[]
	 * @ORM\OneToMany(targetEntity="FeatureTexts", mappedBy="id", indexBy="lang", cascade={"all"})
	 */
	protected $featureTexts;

	/**
	 * @var FeatureValue[]
	 * @ORM\OneToMany(targetEntity="FeatureValue", mappedBy="feature", indexBy="id", cascade={"all"})
	 */
	protected $featureValues;

	/**
	 * Feature constructor.
	 */
	public function __construct()
	{
		$this->featureTexts  = new ArrayCollection();
		$this->featureValues = new ArrayCollection();
		$this->setIsPublished(1);
		$this->setUseAsFilter(0);
		$this->setPosition(-1);
	}

	public function addFeatureText($lang)
	{
		$this->featureTexts->set($lang, new FeatureTexts($this, $lang));
	}

	public function setFeatureText(FeatureTexts $featureTexts)
	{
		$this->featureTexts->set($featureTexts->getLang(), $featureTexts);
	}

	/**
	 * @param $lang
	 *
	 * @return FeatureTexts|null
	 */
	public function getFeatureText($lang)
	{
		return $this->featureTexts->get($lang);
	}

	public function getFeatureTexts() { return $this->featureTexts; }

	public function getFeatureValues()
	{
		return $this->featureValues;
	}


	/******
	 * === Position
	 */

	/**
	 * @param int $position
	 *
	 * @return $this
	 */
	public function setPosition(int $position)
	{
		$this->position = $position;

		return $this;
	}

	/**
	 * @return int
	 */
	public function getPosition() { return $this->position; }

	/******
	 * === Use filter
	 */

	/**
	 * @return int
	 */
	public function getUseAsFilter() { return $this->useAsFilter; }

	/**
	 * @param int $val
	 *
	 * @return $this
	 */
	public function setUseAsFilter($val)
	{
		if ($val && $val == 1)
			$this->useAsFilter = 1;
		else
			$this->useAsFilter = 0;

		return $this;
	}

	/******
	 * === Publish
	 */

	/**
	 * @return int
	 */
	public function getIsPublished() { return $this->isPublished; }

	/**
	 * @param int $val
	 *
	 * @return $this
	 */
	public function setIsPublished($val)
	{
		if ($val && $val == 1)
			$this->isPublished = 1;
		else
			$this->isPublished = 0;

		return $this;
	}
}

