<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use Kdyby\Events\Subscriber;
use Nette\Localization\ITranslator;
use Nette\Caching\Cache;
use Nette\SmartObject;

class ManufacturerListener implements Subscriber
{
	use SmartObject;

	/** @var CacheService */
	protected $cacheService;

	/** @var ITranslator */
	protected $translator;

	public function __construct(CacheService $cacheService, ITranslator $translator)
	{
		$this->cacheService = $cacheService;
		$this->translator   = $translator;
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param object             $entity
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($entity, $args)
	{
	}
}
