<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\Common\Collections\ArrayCollection;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;
use Nette\Utils\DateTime;

/**
 * Class Variant
 * @package EshopCatalog\Model\Entities
 *
 * @ORM\Table(name="eshop_catalog__specific_price_rule")
 * @ORM\Entity
 */
class SpecificPriceRule
{
	use Identifier;
	use MagicAccessors;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", length=1)
	 */
	public $isPublished;

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	private $position;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=255)
	 */
	public $name;

	/**
	 * @var int
	 * @ORM\Column(name="group_id", type="integer", nullable=true)
	 */
	public $groupId;

	/**
	 * @var int
	 * @ORM\Column(name="category_id", type="integer", nullable=true)
	 */
	public $categoryId;

	/**
	 * @var int
	 * @ORM\Column(name="from_quantity", type="integer")
	 */
	public $fromQuantity;

	/**
	 * @var double
	 * @ORM\Column(name="reduction", type="integer", nullable=true)
	 */
	public $reduction;

	/**
	 * @var int
	 * @ORM\Column(name="vat_rate_id", type="integer",  nullable=true)
	 */
	public $vatRateId;

	/**
	 * @var int
	 * @ORM\Column(name="is_percentage", type="smallint", length=1)
	 */
	public $isPercentage;

	/**
	 * @var DateTime
	 * @ORM\Column(name="from_date", type="datetime", nullable=true)
	 */
	public $fromDate;

	/**
	 * @var DateTime
	 * @ORM\Column(name="to_date", type="datetime", nullable=true)
	 */
	public $toDate;

	/******
	 * === Position
	 */

	/**
	 * @param int $position
	 *
	 * @return $this
	 */
	public function setPosition($position)
	{
		$this->position = $position;

		return $this;
	}

	/**
	 * @return int
	 */
	public function getPosition() { return $this->position; }
}
