<?php declare(strict_types = 1);

namespace EshopCatalog\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use EshopCatalog\FrontModule\Model\ProductQuery;
use EshopCatalog\FrontModule\Model\Products;
use Nette\Localization\ITranslator;

class ProductsWithTag extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'eshopCatalogProductsWithTag';

	/** @var Products */
	protected $productsService;

	/** @var ITranslator */
	protected $translator;

	public function __construct(Products $products, ITranslator $translator)
	{
		$this->productsService = $products;
		$this->translator      = $translator;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 */
	public function loadContainer($formContainer, $params = [])
	{
	}

	public function render($params)
	{
		if (!isset($params['toVar']))
			throw new InvalidArgumentException('Need variable for output');
		if (!isset($params['tag']))
			throw new InvalidArgumentException('Need tag for output');
		if (!isset($params['limit']))
			throw new InvalidArgumentException('Need limit for output');

		$query = (new ProductQuery($this->translator->getLocale()))
			->withTag($params['tag'])
			->selectIds();

		$ids = $query->getQueryBuilder($this->productsService->getEr())
			->orderBy('RAND()')->getQuery()
			->setMaxResults($params['limit'])->useResultCache(true, 60)->getScalarResult();

		$products = [];
		foreach ($ids as $id) {
			$p = $this->productsService->get($id['id']);
			if ($p) {
				$this->productsService->loadFeatures($p);
				$products[$id['id']] = $p;
			}
		}

		return $products;
	}
}
