<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopCatalog\Model\Entities\Tag;

/**
 * Class Tags
 * @package EshopCatalog\AdminModule\Model
 *
 * @method Tag|null|object = getReference($id)
 * @method Tag[]|null getAll()
 * @method Tag|null get($id)
 */
class Tags extends BaseEntityService
{
	protected $entityClass = Tag::class;

	public function getByType(string $type): ?Tag
	{
		return $this->getEr()->createQueryBuilder('t')->addSelect('tt')
			->leftJoin('t.texts', 'tt')
			->where('t.type = :type')->setParameter('type', $type)
			->getQuery()->getOneOrNullResult();
	}
}
