<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use Core\Model\Helpers\Traits\TPublish;
use EshopCatalog\Model\Entities\VariantValue;

/**
 * Class VariantValues
 * @package EshopCatalog\AdminModule\Model
 *
 * @method VariantValue|null|object = getReference($id)
 * @method VariantValue[]|null getAll()
 * @method VariantValue|null get($id)
 */
class VariantValues extends BaseEntityService
{
	use TPublish;

	protected $entityClass = VariantValue::class;

	/**
	 * @param int $id
	 * @param int $position
	 *
	 * @return bool
	 * @throws \Exception
	 */
	public function setPosition($id, $position)
	{
		if ($item = $this->getReference($id)) {
			$item->setPosition((int) $position);
			$this->em->persist($item);
			$this->em->flush();

			return true;
		}

		return false;
	}
}
