<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components;

use Core\Model\UI\BaseControl;
use EshopCatalog\FrontModule\Model\Dao\Product;
use EshopCatalog\FrontModule\Model\ProductsFacade;

class ProductPreview extends BaseControl
{
	/** @var ProductsFacade */
	protected $productsFacade;

	/** @var ICartAddFormFactory */
	protected $cartAddFormFactory;

	/** @var Product */
	protected $product;

	/** @var string */
	public $templateFileName = 'ProductPreview';

	public function __construct(ProductsFacade $productsFacade, ICartAddFormFactory $cartAddForm)
	{
		$this->productsFacade     = $productsFacade;
		$this->cartAddFormFactory = $cartAddForm;
	}

	public function render()
	{
		$this->template->product = $this->product;
		$this->template->render($this->getTemplateFile($this->templateFileName, 'ProductPreview'));
	}

	public function createComponentCartAddForm(): CartAddForm
	{
		$control = $this->cartAddFormFactory->create();
		$control->setProduct($this->product);

		return $control;
	}

	public function setProduct(Product $product): self
	{
		$this->product = $product;

		return $this;
	}

	public function setProductById(int $id): self
	{
		$this->product = $this->productsFacade->getProduct($id);

		return $this;
	}
}
