<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\Common\Collections\ArrayCollection;
use Kdyby\Doctrine\Entities\Attributes\Identifier;
use Kdyby\Doctrine\Entities\MagicAccessors;

/**
 * @ORM\Table(name="eshop_catalog__feature_value")
 * @ORM\Entity
 * @ORM\EntityListeners({"FeatureValueListener", "Core\Model\Entities\TranslateListener"})
 */
class FeatureValue
{
	use Identifier;
	use MagicAccessors;
	use TTranslateListener;

	/**
	 * @var Feature
	 * @Gedmo\SortableGroup
	 * @ORM\ManyToOne(targetEntity="Feature", inversedBy="id", cascade={"persist"})
	 * @ORM\JoinColumn(name="feature_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	protected $feature;

	/**
	 * @var FeatureValueTexts
	 * @ORM\OneToMany(targetEntity="FeatureValueTexts", mappedBy="id", indexBy="lang")
	 */
	protected $featureValueTexts;

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	private $position;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", nullable=true, options={"default"=0})
	 */
	protected $isPublished;

	/**
	 * FeatureValue constructor.
	 */
	public function __construct()
	{
		$this->featureValueTexts = new ArrayCollection();
		$this->isPublished       = 0;
		$this->setPosition(-1);
	}

	public function addFeatureValueText($lang)
	{
		$this->featureValueTexts->set($lang, new FeatureValueTexts($this, $lang));
	}

	/**
	 * @param string|null $lang
	 *
	 * @return null
	 */
	public function getFeatureValueText(?string $lang = null) { return $this->featureValueTexts[$lang ?: $this->locale] ?: null; }

	/**
	 * @return ArrayCollection|FeatureValueTexts[]
	 */
	public function getFeatureValueTexts() { return $this->featureValueTexts; }

	public function setFeature(Feature $feature)
	{
		$this->feature = $feature;
	}

	public function setFeatureValueText(FeatureValueTexts $featureValueTexts)
	{
		$this->featureValueTexts->set($featureValueTexts->getLang(), $featureValueTexts);
	}

	public function setTexts(array $texts)
	{
		$this->featureValueTexts = new ArrayCollection($texts);
	}

	public function getFeature()
	{
		return $this->feature;
	}

	/******
	 * === Position
	 */

	/**
	 * @param int $position
	 *
	 * @return $this
	 */
	public function setPosition(int $position)
	{
		$this->position = $position;

		return $this;
	}

	/**
	 * @return int
	 */
	public function getPosition() { return $this->position; }
}

