<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Navigation\Home;
use Kdyby\Events\Subscriber;
use Nette\Localization\ITranslator;
use Nette\Caching\Cache;
use Nette\SmartObject;

class ProductTextListener implements Subscriber
{
	use SmartObject;

	/** @var array */
	protected static $cleared = [];

	/** @var CacheService */
	protected $cacheService;

	/** @var ITranslator */
	protected $translator;

	public function __construct(ITranslator $translator, CacheService $cacheService)
	{
		$this->cacheService = $cacheService;
		$this->translator   = $translator;
	}

	public function getSubscribedEvents()
	{
		return [];
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param ProductTexts       $productText
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($productText, $args)
	{
		if (!self::$cleared[$productText->getProduct()->getId()]) {
			bdump("product '{$productText->getProduct()->getId()}' text pre flush");
			$this->cacheService->clean('product', [
				Cache::TAGS => [
					'product/' . $productText->getProduct()->getId(),
				],
			]);
			$this->cacheService->clean('navigation', [
				Cache::TAGS => [
					Home::CACHE_PRODUCT . '/' . $productText->getProduct()->getId(),
				],
			]);
		}

		self::$cleared[$productText->getProduct()->getId()] = true;
	}
}
