import noUiSlider           from 'nouislider'
import {slideDown, slideUp} from "es6-slide-up-down";
import {checkMedia}         from './utilities/utitlities'
import {addEventForChild}   from '../../../../../core/assets/admin/src/js/utils/Functions';
import {scrollTo}           from "core/js/utils/utilities";
import {FormatMoney}        from 'core/js/utils/formatMoney';

window.showSearch = function () {
	document.querySelector('.shop-header__search').classList.toggle('active');
};

document.addEventListener('DOMContentLoaded', () => {
	/**
	 * Inicializace price filtru pro ProductsFilter.latte
	 */
	initPriceRange();
	initShowMore();
	initShowFilter();
	setAjaxFilter();

	/**
	 * Inicializace po requestu
	 */
	global.naja.addEventListener('complete', e => {
		initPriceRange();
		initShowMore();
		initShowFilter();
		setAjaxFilter();
	});

	/**
	 * Popup na varianty funkce
	 */
	document.addEventListener('click', e => {
		const el = e.target;

		if (el.matches('.variant-box__value') && el.closest('.modal')) {
			e.preventDefault();

			// Nastaveni ID produktu do komponenty kosiku
			document.querySelector('.variant-modal [name="productId"]').value = el.dataset.id;

			document.querySelectorAll('.variant-box__value').forEach(el => el.classList.remove('light-grey-bg-color'))
			el.classList.add('light-grey-bg-color');
			const variant    = {
				id         : el.dataset.id,
				price      : el.dataset.price,
				retailPrice: el.dataset.retailPrice,
				image      : el.dataset.image,
				name       : el.dataset.name,
			};
			const attributes = [];

			let retailPriceEl = document.querySelector('.variant-modal__old-price');
			if (variant.retailPrice) {
				retailPriceEl.textContent = variant.retailPrice;
				retailPriceEl.classList.remove('hidden');
			} else {
				retailPriceEl.classList.add('hidden');
			}
			document.querySelector('.variant-modal__price').textContent = variant.price;
			document.querySelectorAll('.cart-add-wrap').forEach(el => {
				el.classList.add('hidden');
			});
			document.querySelector('.cart-add-wrap[data-id="' + variant.id + '"]').classList.remove('hidden');

			const variantImg          = document.querySelector('.variant-modal__left img');
			variantImg.attributes.src = variant.image;
			variantImg.attributes.alt = variant.name;
		}
	})

	// Presunuti kosiku desktop vs mobil
	moveShopHeaderCart();
	window.addEventListener('resize', (e) => {
		moveShopHeaderCart();
	});
});

/**
 * Vypnuti okamziteho filtrovani na mobilu
 */
const setAjaxFilter = () => {
	let mobileSize    = checkMedia(document.body.dataset.responsiveThresholdEshopFilter);
	const filtersWrap = document.querySelector('.filters__all-wrap');

	if (!filtersWrap)
		return;

	filtersWrap.querySelectorAll('.filters__filter-val').forEach(el => {
		if (mobileSize) {
			el.addEventListener('click', e => {
				e.preventDefault();

				let input     = el.querySelector('input');
				input.checked = !input.checked;
				input.dispatchEvent(new Event('change'));
			})
		} else {
			el.classList.add('ajax');
		}
	});

	if (mobileSize) {
		const eshopProductsFilterForm  = document.getElementById('eshop-products-filter');
		const eshopFilterConfirmButton = document.querySelector('.filters__confirm-btn');

		if (eshopProductsFilterForm && eshopFilterConfirmButton) {
			eshopFilterConfirmButton.addEventListener('click', e => {
				let productsList         = document.querySelector('.product-list');
				let productsListBounding = productsList ? productsList.getBoundingClientRect() : null;

				global.naja.makeRequest('post', eshopProductsFilterForm.action, new FormData(eshopProductsFilterForm), {
					history: false,
				}).then((response) => {
					window.history.pushState('', '', response.url);

					if (productsListBounding) {
						let bodyRect = document.body.getBoundingClientRect();
						scrollTo(productsListBounding.top - bodyRect.top - 100, 200);
					}
				});

				return false;
			});

			eshopProductsFilterForm.addEventListener('submit', e => {
				eshopFilterConfirmButton.dispatchEvent(new Event('click'));
			});
		}
	} else {
		global.naja.uiHandler.bindUI(filtersWrap);
	}
}

let shopHeaderCartLastPos = 'desktop';
const moveShopHeaderCart  = () => {
	let mobileSize = checkMedia(document.body.dataset.responsiveBarThreshold);
	let moveTo     = null;
	if (mobileSize && shopHeaderCartLastPos === 'desktop')
		moveTo = 'mobile';
	else if (!mobileSize && shopHeaderCartLastPos === 'mobile')
		moveTo = 'desktop';

	if (moveTo) {
		let shopHeaderCartMobile  = document.querySelector('.shop-header__cart-mobile');
		let shopHeaderCartDesktop = document.querySelector('.show-header__cart-desktop');

		if (moveTo === 'mobile') {
			while (shopHeaderCartDesktop.childNodes.length > 0)
				shopHeaderCartMobile.appendChild(shopHeaderCartDesktop.childNodes[0]);
			shopHeaderCartLastPos = 'mobile';
		} else if (moveTo === 'desktop') {
			while (shopHeaderCartMobile.childNodes.length > 0)
				shopHeaderCartDesktop.appendChild(shopHeaderCartMobile.childNodes[0]);
			shopHeaderCartLastPos = 'desktop';
		}
	}
}

const initPriceRange = () => {
	let slider = document.getElementById('price-slider');

	if (!slider || slider.classList.contains('init'))
		return;

	slider.classList.add('init');

	const min   = parseFloat(slider.dataset.min).toFixed(2);
	const max   = parseFloat(slider.dataset.max).toFixed(2);
	const start = parseFloat(slider.dataset.start).toFixed(2);
	const end   = parseFloat(slider.dataset.end).toFixed(2);

	const parent = slider.parentNode;
	const input0 = parent.querySelector('#input-with-keypress-0');
	const input1 = parent.querySelector('#input-with-keypress-1');
	const inputs = [input0, input1];

	noUiSlider.create(slider, {
		start   : [min, max],
		range   : {
			min: parseFloat(start),
			max: parseFloat(end),
		},
		tooltips: [true, true],
		connect : true,
		format  : {
			to  : function (value) {
				return FormatMoney.format(Math.round(value), 0) + ' ' + slider.dataset.currency;
			},
			from: function (value) {
				return Number(value.replace(',-', ''));
			}
		}
	});

	slider.noUiSlider.on('change', function (values, handle, unencoded, tap, positions) {
		let min  = parseFloat(unencoded[0]).toFixed(2);
		let max  = parseFloat(unencoded[1]).toFixed(2);
		let link = slider.dataset.updateLink;

		let urlParamsBase = link.split('?');
		let urlParams     = urlParamsBase[1].split('&');

		document.querySelector('[name="priceRange[min]"]').value = min;
		document.querySelector('[name="priceRange[max]"]').value = max;

		if (start == min) {
			let k = urlParams.findIndex(a => a == 'productsFilter-min=__min__');
			if (k !== -1)
				delete urlParams[k];
		}
		if (end == max) {
			let k = urlParams.findIndex(a => a == 'productsFilter-max=__max__');
			if (k !== -1)
				delete urlParams[k];
		}

		urlParams = urlParams.filter(Boolean);

		link = urlParamsBase[0] + (urlParams.length ? '?' : '') + urlParams.join('&');
		link = link.replace('__min__', min).replace('__max__', max);

		if (checkMedia(768, 'min')) {
			global.naja.makeRequest('get', link, [], {
				history: true,
			});
		}

	});

	slider.noUiSlider.on('update', function (values, handle, rawValue, bool, percentageValue) {
		inputs[handle].innerHTML = values[handle];
	});
};

/**
 * Skryvani a odkryvani pomoci zobrazit dalsi
 * TODO temporary fix for IE SlideDown / Up
 */
const initShowMore = () => {
	document.querySelectorAll('[data-show-more]').forEach(el => {
		if (el.dataset.showMore === 'init')
			return true;

		el.addEventListener('click', (e) => {
			e.preventDefault();
			const targetEl = el.parentNode.querySelector('[data-hidden-content]');
			if (!targetEl.classList.contains('active')) {
				targetEl.style.display = "block";
				targetEl.classList.add('active');
				el.classList.add('filters__show-more--active');
				el.querySelector('span').textContent = el.dataset.hide;
			} else {
				targetEl.style.display = "none";
				targetEl.classList.remove('active');
				el.classList.remove('filters__show-more--active');
				el.querySelector('span').textContent = el.dataset.show;
			}
		});
	});
}

/**
 * Skryvani a odkryvani filtru
 */
const initShowFilter = () => {
	const showOnDesktop = document.querySelector('[data-show-filter-desktop]');
	if (!showOnDesktop && checkMedia(768, 'min'))
		return;
	//if (checkMedia(768, 'min'))
		//return;

	document.querySelectorAll('[data-show-filter]').forEach(el => {
		if (el.showFilterInit === true)
			return;
	
		el.showFilterInit = true;
		el.addEventListener('click', () => {
			const id            = el.dataset.showFilter;
			const parent        = el.parentNode;
			const targetElement = parent.querySelector(`[data-filter-group="${id}"]`);
			if (!targetElement.classList.contains('active')) {
				slideDown(targetElement, 200);
				targetElement.classList.add('active');
				targetElement.closest('.filters__row').classList.add('active');
			} else {
				slideUp(targetElement, 200);
				targetElement.classList.remove('active');
				targetElement.closest('.filters__row').classList.remove('active');
			}
		});
	});
}

/**
 * Skryvani a odkryvani polozek v eshop-nav__secondary
 */
document.querySelectorAll('[data-show-more-items]').forEach(el => {
	el.addEventListener('click', () => {
		const moreText = el.getAttribute('data-more-text');
		const lessText = el.getAttribute('data-less-text');
		const text = el.querySelector('div');
		const parent        = el.parentNode;
		const targetElement = parent.querySelector(`[data-hidden-items]`);
		if (!targetElement.classList.contains('active')) {
			slideDown(targetElement);
			text.innerHTML = lessText;
			targetElement.classList.add('active');
		} else {
			slideUp(targetElement);
			text.innerHTML = moreText;
			targetElement.classList.remove('active');
		}
	});
});

