import {checkMedia} from "eshopcatalog/js/utilities/utitlities";

document.addEventListener('change', e => {
	const target = e.target;

	if (target.id === 'items-per-page') {
		window.location.href = target.options[target.selectedIndex].dataset.link;
	}
});

const initFilterTitleToggle = () => {
	const itemsFilterTitle = document.querySelector('.filters__main-title');

	if (itemsFilterTitle) {
		if (itemsFilterTitle.filterTitleToogleInit === true)
			return;

		itemsFilterTitle.filterTitleToogleInit = true;

		itemsFilterTitle.addEventListener('click', e => {
			itemsFilterTitle.classList.toggle('active');
		});
	}
};

initFilterTitleToggle();
global.naja.addEventListener('complete', e => {
	initFilterTitleToggle();
});

document.addEventListener('DOMContentLoaded', () => {
	const categoryIntro  = document.querySelector('.category .category-intro');
	const productsFilter = document.querySelector('.col-products-filter');
	let mobileSize       = checkMedia(document.body.dataset.responsiveBarThreshold);
	if (categoryIntro && productsFilter && mobileSize) {
		categoryIntro.remove();
		productsFilter.prepend(categoryIntro);
	}
});
