<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\Products;

use Core\Model\UI\BaseControl;
use Core\Model\UI\Form\BaseForm;
use EshopCatalog\AdminModule\Model\Products;
use EshopCatalog\Model\Entities\Product;
use EshopCatalog\Model\Entities\ProductTag;
use EshopCatalog\Model\Entities\Tag;
use Nette\Utils\ArrayHash;

class ProductTagsForm extends BaseControl
{
	/** @var TagsContainer */
	protected TagsContainer $tagsContainer;

	/** @var Products */
	protected Products $products;

	public function __construct(TagsContainer $tagsContainer, Products $products)
	{
		$this->tagsContainer = $tagsContainer;
		$this->products      = $products;
	}

	public function render(): void
	{
		$this->template->thisForm = $this['form'];
		$this->template->render($this->getTemplateFile());
	}

	/**
	 * @return BaseForm
	 */
	public function createComponentForm(): BaseForm
	{
		$form = $this->createForm();
		$form->addComponent($this->tagsContainer->getContainer(), 'tags');
		$form->addCheckbox('removeDisabled', 'eshopCatalog.productTagsForm.removeDisabledFromProducts')
			->setDefaultValue(0);

		$form->addSaveCancelControl('saveControl');

		$form->onSuccess[] = [$this, 'formSuccess'];

		return $form;
	}

	/**
	 * @param BaseForm  $form
	 * @param ArrayHash $values
	 *
	 * @return bool
	 * @throws \Doctrine\ORM\ORMException
	 */
	public function formSuccess(BaseForm $form, ArrayHash $values): bool
	{
		$productsIds = $this->presenter->getParameter('ids');
		$form->addCustomData('productIds', $productsIds);

		if ($productsIds) {
			$productsIds = explode('-', $productsIds);
			/** @var ProductTag[][] $activeTags */
			$activeTags = [];
			foreach ($this->em->getRepository(ProductTag::class)->createQueryBuilder('pt')
				         ->andWhere('pt.product IN (:ids)')->setParameter('ids', $productsIds)
				         ->getQuery()->getResult() as $row) {
				/** @var ProductTag $row */
				$activeTags[$row->getTag()->getId()][$row->getProduct()->getId()] = $row;
			}

			foreach ($values->tags as $key => $vals) {
				if ($vals->active === 0) {
					// Odstranit neaktivni pokud je zvoleno
					if ($values->removeDisabled === true) {
						foreach ($activeTags[$vals->id] as $productId => $productTag) {
							$this->em->remove($productTag);
						}
					}

					continue;
				}

				// Projdutui vybranuch produkt a prirazeni stitku
				foreach ($productsIds as $productId) {
					/** @var ProductTag|null $productTag */
					$productTag = $activeTags[$vals->id][$productId] ?? null;
					if (!$productTag)
						$productTag = new ProductTag($this->em->getReference(Product::class, $productId), $this->em->getReference(Tag::class, $vals->id));

					$productTag->validFrom = $vals->dateFrom;
					$productTag->validTo   = $vals->dateTo;
					$this->em->persist($productTag);
				}
			}

			$this->em->flush();
		}

		return true;
	}
}
