<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use Core\Model\Dao\Country;
use Nette\Utils\Html;

class Seller
{
	public int $id;

	/** @var string */
	public $title;

	/** @var string */
	public $name;

	/** @var string */
	public $street;

	/** @var string */
	public $city;

	/** @var string */
	public $postal;

	/** @var Country|null */
	public ?Country $country = null;

	/** @var string */
	public $street2;

	/** @var string */
	public $city2;

	/** @var string */
	public $postal2;

	/** @var Country|null */
	public ?Country $country2 = null;

	/** @var string */
	public $ic;

	/** @var string */
	public $dic;

	/** @var string */
	public $email;

	/** @var string */
	public $phone;

	/** @var BankAccount|null */
	protected $bankAccount;

	public bool $sendOrderToSeller = true;

	public bool $sendStatusToSeller = true;

	public string $sendSellerEmailType = 'seller';

	public function __construct(int $id)
	{
		$this->id = $id;
	}

	public function getBankAccount(): ?BankAccount { return $this->bankAccount; }

	public function setBankAccount(BankAccount $bankAccount): self
	{
		$this->bankAccount = $bankAccount;

		return $this;
	}

	public function renderAddress(string $number = '', array $skip = []): Html
	{
		$wrap = Html::el();
		$rows = [];

		if ($this->{'street' . $number})
			$wrap->addHtml(Html::el('div')->setText($this->{'street' . $number}));

		$postal = $this->{'postal' . $number} ?? null;
		if ($this->{'city' . $number})
			$wrap->addHtml(Html::el('div')->setText(($postal ? $postal . ', ' : '') . $this->{'city' . $number}));

		if ($this->{'country' . $number} && !in_array('country', $skip))
			$wrap->addHtml(Html::el('div')->setText($this->{'country'}->getName()));

		return $wrap;
	}

	public function isVatPayer(): bool { return $this->dic ? true : false; }
}
