<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Subscribers;

use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use EshopCatalog\Model\Config;
use EshopCatalog\Model\Entities\Product;
use EshopOrders\FrontModule\Model\Event\OrderEvent;
use Core\Model\Entities\EntityManagerDecorator;

class OrderPseudoWarehouseSubscriber implements EventSubscriberInterface
{
	protected EntityManagerDecorator $em;

	public function __construct(EntityManagerDecorator $em)
	{
		$this->em = $em;
	}

	public static function getSubscribedEvents(): array
	{
		return [
			'eshopOrders.orderOnSuccess' => ['orderOnSuccess', 100],
		];
	}

	public function orderOnSuccess(OrderEvent $event): void
	{
		if (!Config::load('pseudoWarehouse'))
			return;

		$products = [];
		foreach ($event->order->getOrderItems() as $v) {
			$products[] = $v->getProductId();
		}

		$unlimited = [];
		foreach ($this->em->getRepository(Product::class)->createQueryBuilder('p')
			         ->select('p.id')
			         ->where('p.id IN (:ids)')->setParameter('ids', $products)
			         ->andWhere('p.unlimitedQuantity = 1')
			         ->getQuery()->getScalarResult() as $row)
			$unlimited[] = $row['id'];

		// Aktualizace počtu ks
		foreach ($event->order->getOrderItems() as $v) {
			if (!$v->getProductId() || in_array($v->getProductId(), $unlimited))
				continue;

			$product           = $this->em->getReference(Product::class, $v->getProductId());
			$product->quantity -= $v->getQuantity();
			$this->em->persist($product);
			$this->em->flush($product);
		}
	}
}
