<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TId;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="eshop_catalog__feature_product")
 * @ORM\Entity
 * @ORM\EntityListeners({"FeatureProductListener"})
 */
class FeatureProduct
{
	use TId;

	/**
	 * @var Product
	 *
	 * @ORM\ManyToOne(targetEntity="Product", inversedBy="FeatureProduct", cascade={"persist"})
	 * @ORM\JoinColumn(name="id_product", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $product;

	/**
	 * @var FeatureValue
	 *
	 * @ORM\ManyToOne(targetEntity="FeatureValue", cascade={"persist"})
	 * @ORM\JoinColumn(name="id_feature_value", referencedColumnName="id", onDelete="CASCADE")
	 */
	private $featureValue;

	public function __construct(Product $product, FeatureValue $featureValue)
	{
		$this->product      = $product;
		$this->featureValue = $featureValue;
	}

	public function getFeature()
	{
		return $this->getFeatureValue()->getFeature();
	}

	public function getFeatureValue()
	{
		return $this->featureValue;
	}

	public function getIdProduct()
	{
		return $this->product->getId();
	}

	public function getIdFeature()
	{
		return $this->getFeature()->getId();
	}

	public function getIdFeatureValue()
	{
		return $this->featureValue->getId();
	}

	public function setFeature(Feature $feature)
	{
//		$this->feature = $feature;
	}

	public function setFeatureValue(FeatureValue $featureValue)
	{
		return $this->featureValue = $featureValue;
	}
}
