<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Doctrine\Common\Collections\ArrayCollection;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="eshop_catalog__manufacturer", indexes={
 *     @ORM\Index(name="id_name", columns={"id", "name"})
 * })
 * @ORM\Entity
 * @ORM\EntityListeners({"ManufacturerListener"})
 */
class Manufacturer
{
	use TId;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=255)
	 */
	public $name;

	/**
	 * @var string
	 * @ORM\Column(name="logo", type="string", length=255, nullable=true)
	 */
	public $logo;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", length=1)
	 */
	public $isPublished;

	/**
	 * @var ManufacturerTexts[]
	 * @ORM\OneToMany(targetEntity="ManufacturerTexts", mappedBy="id", indexBy="lang", cascade={"all"})
	 */
	protected $texts;

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	private $position;

	/**
	 * Manufacturer constructor.
	 */
	public function __construct()
	{
		$this->texts       = new ArrayCollection();
		$this->isPublished = 1;
		$this->setPosition(-1);
	}

	public function addManufacturerText($lang)
	{
		$this->manufacturerTexts->set($lang, new ManufacturerTexts($this, $lang));
	}

	public function setManufacturerText(ManufacturerTexts $manufacturerTexts)
	{
		$this->manufacturerTexts->set($manufacturerTexts->getLang(), $manufacturerTexts);
	}

	/**
	 * @param string $lang
	 *
	 * @return ManufacturerTexts|null
	 */
	public function getText($lang) { return $this->texts->get($lang); }

	/**
	 * @return ArrayCollection|ManufacturerTexts[]
	 */
	public function getTexts() { return $this->texts; }

	/******
	 * === Position
	 */

	/**
	 * @param int $position
	 *
	 * @return $this
	 */
	public function setPosition($position)
	{
		$this->position = $position;

		return $this;
	}

	/**
	 * @return int
	 */
	public function getPosition() { return $this->position; }
}
