<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="eshop_catalog__vat_rate")
 * @ORM\Entity
 */
class VatRate
{
	use TId;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=255)
	 */
	public $name;

	/**
	 * @var int
	 * @ORM\Column(name="rate", type="smallint")
	 */
	public $rate;

	public function getModifier(): float
	{
		return round($this->rate / 100 * 1, 2);
	}
}
