<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Helpers;

use Core\Model\Entities\EntityManagerDecorator;
use EshopCatalog\Model\Entities\ProductVariant;

class VariantsHelper
{
	protected EntityManagerDecorator $em;

	protected array $cLoaded = [];

	protected bool $allLoaded = false;

	public function __construct(EntityManagerDecorator $em)
	{
		$this->em = $em;
	}

	public function getAllVariants()
	{
		if (!$this->allLoaded) {
			$this->allLoaded = true;
			$map             = [];

			foreach ($this->em->createQueryBuilder()->from(ProductVariant::class, 'pv')
				         ->select('IDENTITY(pv.product) as id, pv.isDefault, pv.variantId')
				         ->orderBy('pv.isDefault', 'DESC')
				         ->getQuery()->getScalarResult() as $row) {
				if ($row['isDefault'] === 1) {
					$this->cLoaded[$row['id']] = [];
					$map[$row['variantId']]    = $row['id'];
				} else {
					$this->cLoaded[$map[$row['variantId']]][] = $row['id'];
				}
			}
		}

		return $this->cLoaded;
	}

	public function getProductVariants(int $productId)
	{
		if (!isset($this->cLoaded[$productId])) {
			$this->cLoaded[$productId] = [];

			$variantId = $this->em->createQueryBuilder()
					->select('pv.variantId')->from(ProductVariant::class, 'pv')
					->where('pv.product = :prod')
					->setParameter('prod', $productId)
					->getQuery()->getScalarResult()[0]['variantId'] ?? null;

			if ($variantId) {
				foreach ($this->em->createQueryBuilder()->from(ProductVariant::class, 'pv')
					         ->select('IDENTITY(pv.product) as id')
					         ->where('pv.variantId = :varId')
					         ->andWhere('pv.isDefault = 0')
					         ->setParameter('varId', $variantId)
					         ->getQuery()->getScalarResult() as $row) {
					$this->cLoaded[$productId][] = $row['id'];
				}
			}
		}

		return $this->cLoaded[$productId];
	}
}
