<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Model\Dao;

use EshopCatalog\Model\Helpers\DocumentsHelper;

class Document
{
	/** @var string */
	protected string $name;

	/** @var string */
	protected string $file;

	/** @var null|string */
	protected $lang = null;

	/**
	 * Document constructor.
	 *
	 * @param string      $name
	 * @param string      $file
	 * @param string|null $lang
	 */
	public function __construct(string $name, string $file, $lang = null)
	{
		$this->name = $name;
		$this->file = $file;
		$this->lang = $lang;
	}

	/**
	 * @return bool
	 */
	public function isSecured(): bool { return DocumentsHelper::isSecured($this->file); }

	/**
	 * @return string
	 */
	public function getFilePath(): string { return $this->isSecured() ? '#' : $this->file; }

	/**
	 * @return string
	 */
	public function getName(): string { return $this->name; }

	/**
	 * @return string|null
	 */
	public function getLang() { return $this->lang; }
}
