<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="eshop_catalog__category_filter")
 * @ORM\Entity
 * @ORM\EntityListeners({"CategoryFilterListener"})
 */
class CategoryFilter
{

	/**
	 * @var Category
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Category", inversedBy="filters")
	 * @ORM\JoinColumn(name="category_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $category;

	/**
	 * @var Feature
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Feature")
	 * @ORM\JoinColumn(name="feature_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	public $feature;

	/**
	 * @var int
	 * @ORM\Column(name="position", type="integer")
	 */
	public $position;

	/**
	 * CategoryFilter constructor.
	 *
	 * @param Category $category
	 * @param Feature  $feature
	 * @param int      $position
	 */
	public function __construct(Category $category, Feature $feature, int $position)
	{
		$this->category = $category;
		$this->feature  = $feature;
		$this->position = $position;
	}
}
