<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\Site;
use Doctrine\ORM\Mapping as ORM;

/**
 * @ORM\Table(name="eshop_catalog__product_in_site")
 * @ORM\Entity
 * @ORM\EntityListeners({"ProductInSiteListener"})
 */
class ProductInSite
{

	/**
	 * @var Product
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	protected $product;

	/**
	 * @var Site
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="Core\Model\Entities\Site")
	 * @ORM\JoinColumn(name="site", referencedColumnName="ident", nullable=false, onDelete="CASCADE")
	 */
	protected $site;

	/**
	 * @var int
	 * @ORM\Column(name="is_active", type="smallint", nullable=false, options={"default": 0})
	 */
	protected $isActive;

	/**
	 * @var Category
	 * @ORM\ManyToOne(targetEntity="Category")
	 * @ORM\JoinColumn(name="category_id", referencedColumnName="id", nullable=true, onDelete="SET NULL")
	 */
	public $category;

	public function __construct(Product $product, Site $site)
	{
		$this->product  = $product;
		$this->site     = $site;
		$this->isActive = 0;
	}

	public function getProduct(): Product { return $this->product; }

	public function getSite(): Site { return $this->site; }

	public function isActive() { return $this->isActive; }

	public function setActive(int $active = 1): self
	{
		$this->isActive = (int) $active;

		return $this;
	}
}
