<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;

/**
 * @ORM\Table(name="eshop_catalog__related_group_text")
 * @ORM\Entity
 */
class RelatedGroupText
{
	/**
	 * @var RelatedGroup
	 * @ORM\Id
	 * @ORM\ManyToOne(targetEntity="RelatedGroup", inversedBy="texts", cascade={"persist", "remove"})
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", onDelete="CASCADE")
	 */
	private RelatedGroup $group;

	/**
	 * @ORM\Id
	 * @ORM\Column(name="lang", type="string", length=2, nullable=false)
	 */
	private string $lang;

	/**
	 * @var string
	 * @ORM\Column(name="name", type="string", length=255, nullable=true)
	 */
	protected ?string $name = null;

	public function __construct(RelatedGroup $group, string $lang)
	{
		$this->group = $group;
		$this->lang  = $lang;
	}

	/**
	 * @param string $name
	 *
	 * @return $this
	 */
	public function setName(string $name): self
	{
		$this->name = $name;

		return $this;
	}

	/**
	 * @return string
	 */
	public function getName() { return $this->name; }

	/**
	 * @return RelatedGroup
	 */
	public function getGroup(): RelatedGroup { return $this->group; }

	/**
	 * @return string
	 */
	public function getLang(): string { return $this->lang; }
}

