document.addEventListener('autocompleteOnSelection', e => {
	if (e.detail.name !== 'relatedCategory' && e.detail.name !== 'virtualCategory')
		return;

	const resp       = e;
	const input      = resp.target;
	const allWrap    = input.closest('.row');
	const addLink    = allWrap.dataset.addLink;
	const removeLink = allWrap.dataset.removeLink;
	const selection  = resp.detail.selection;

	global.naja.makeRequest('post', addLink, {
		target: selection.value.id,
		key   : input.dataset.targetKey,
	}, {
		history: false,
	}).then(response => {
		if (response.result !== 'ok')
			return;

		input.value = '';

		let tr = document.createElement('tr');
		tr.setAttribute('data-id', response.id);

		let id = document.createElement('td');
		id.classList.add('w1nw', 'text-right');
		id.textContent = response.id;

		let name         = document.createElement('td');
		name.textContent = selection.value.name;

		let key = document.createElement('td');
		key.classList.add('w1nw');
		key.textContent = response.key;

		let actions = document.createElement('td');
		actions.classList.add('w1nw');
		actions.innerHTML = '<a href="#" class="btn btn-xs btn-danger related-categories-remove-item" data-remove-link="' + removeLink + '" data-id="' + response.id + '">' +
			'<i class="fas fa-times"></i></a>' +
			'<span class="handle-sort btn btn-xs btn-default btn-secondary"><i class="fas fa-sort"></i></span>';

		tr.appendChild(id);
		tr.appendChild(name);
		tr.appendChild(key);
		tr.appendChild(actions);
		document.querySelector('table.related-values tbody').appendChild(tr);
	});
})

document.addEventListener('click', e => {
	let target = e.target;

	if (target.matches('.related-categories-remove-item') && target.dataset.removeLink) {
		global.naja.makeRequest('post', target.dataset.removeLink, {
			id: target.dataset.id,
		}, {
			history: false,
		}).then(response => {
			if (response.result !== 'ok')
				return;

			target.parentElement.parentElement.remove();
		});
	}
})
