<?php declare(strict_types=1);

namespace EshopCatalog\AdminModule\Model\Event;

use EshopCatalog\Model\Entities\Seller;
use Nette\Utils\ArrayHash;
use Symfony\Contracts\EventDispatcher\Event;

class SellerEvent extends Event
{
	/** @var Seller */
	public Seller $seller;

	/** @var ArrayHash */
	public ArrayHash $formData;

	/**
	 * SellerEvent constructor.
	 * @param Seller $seller
	 * @param array $formData
	 */
	public function __construct(Seller $seller, ArrayHash $formData)
	{
		$this->seller = $seller;
		$this->formData = $formData;
	}

}