<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Model;

use Core\Model\Helpers\BaseEntityService;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Entities\ProductDocument;

/**
 * @method ProductDocument get($id)
 */
class ProductDocuments extends BaseEntityService
{
	protected $entityClass = ProductDocument::class;

	protected CacheService $cacheService;

	public function __construct(CacheService $cacheService)
	{
		$this->cacheService = $cacheService;
	}

	/**
	 * @param int $productId
	 *
	 * @return ProductDocument
	 */
	public function getByProduct(int $productId): array
	{
		$qb = $this->getEr()->createQueryBuilder('pd');

		return $qb->join('pd.product', 'p')
			->where('p.id = :pid')
			->setParameter('pid', $productId)
			->getQuery()->getResult();
	}

	public function remove($id)
	{
		$document = $this->get($id);

		if ($document) {
			$productId = $document->product->getId();
			$result    = parent::remove($id);
			$this->cacheService->removeDocuments([$productId]);

			return $result;
		}

		return false;
	}
}
