<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components;

use Core\Components\Navigation\DaoNavigationItem;
use Core\Model\Navigation\Alias;
use Core\Model\UI\BaseControl;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\FrontModule\Model\Categories;
use EshopCatalog\FrontModule\Model\Dao\Category;
use Navigations\Model\Navigations;
use Nette\Http\Request;

/**
 * Class Navigation
 * @package EshopCatalog\FrontModule\Components
 */
class Navigation extends BaseControl
{
	/** @var DaoNavigationItem[] */
	protected $navs;

	/** @var string */
	protected $navigationType;

	/** @var Navigations */
	protected $navigationsService;

	/** @var Categories */
	protected $categoriesService;

	/** @var CacheService */
	protected $cacheService;

	/** @var bool */
	protected $cacheCleaned = false;

	/** @var array */
	protected $cByParent;

	protected ?array $cCategories = null;

	public array $otherCategories = [];
	public array $editedLinks     = [];

	public $currentCategoryId = null;

	/** @var Category */
	protected $currentCategory;

	/** @var Request */
	protected $httpRequest;

	public function __construct(Navigations $navigations, Categories $categories, CacheService $cacheService, Request $request)
	{
		$this->navigationsService = $navigations;
		$this->categoriesService  = $categories;
		$this->cacheService       = $cacheService;
		$this->httpRequest        = $request;
	}

	protected function attached($presenter): void
	{
		parent::attached($presenter);
	}

	public function render($template = 'Default'): void
	{
		$navs = $this->getNavs();
		$this->checkIsCurrent($navs);

		$this->template->navs              = $navs;
		$this->template->getCategories     = function() { return $this->getCategories() + $this->otherCategories; };
		$this->template->currentCategoryId = $this->currentCategoryId ?: $this->getPresenter()->getParameter('id');
		$this->template->editedLinks       = $this->editedLinks;

		$this->template->render($this->getTemplateFile($template));
	}

	/*******************************************************************************************************************
	 * ============================== Get / Set
	 */

	public function getCategories()
	{
		if ($this->cCategories === null) {
			$this->cCategories = $this->categoriesService->getCategories($this->categoriesService->getRootIdForSite());
		}

		return $this->cCategories;
	}

	/**
	 * @return DaoNavigationItem[]
	 */
	public function getNavs(): array
	{
		if (!$this->navs) {
			$allNavs = $this->navigationsService->getPublishedToDaoNavigationItem();
			foreach ($this->navigationsService->getPublishedDaoNavigationStructure()[$this->navigationType] ?? [] as $nav) {
				/** @var $nav DaoNavigationItem */
				if ($nav->componentType === Alias::TYPE) {
					$tmp = $allNavs[$nav->componentParams['navigation'][$this->translator->getLocale()]] ?? null;
					if ($tmp) {
						$this->navs[$tmp->id] = $tmp;
						continue;
					}
				}

				$this->navs[$nav->id] = $nav;
			}
		}

		return $this->navs ?: [];
	}

	/**
	 * @param string $type
	 *
	 * @return $this
	 */
	public function setNavigationType($type): self
	{
		$this->navigationType = $type;

		return $this;
	}

	private function checkIsCurrent(&$data)
	{
		$presenter = $this->getPresenter();

		$fn = function(&$data) use (&$fn, $presenter) {
			foreach ($data as $nav) {
				if ($nav->isHomepage)
					continue;

				$path      = explode('/', $this->httpRequest->getUrl()->path);
				$isCurrent = false;

				do {
					if (implode('/', $path) == $nav->link) {
						$isCurrent = true;
						break;
					}

					array_pop($path);
				} while (!empty($path));

				if ($isCurrent) {
					$nav->set('isCurrent', true);
				}

				if ($nav->childs) {
					$fn($nav->childs);

					foreach ($nav->childs as $child) {
						if ($child->isCurrent) {
							$nav->set('isCurrent', true);
							break;
						}
					}
				}
			}
		};

		$fn($data);
	}
}
