<?php declare(strict_types = 1);

namespace EshopCatalog\FrontModule\Components;

use Core\Model\UI\BaseControl;
use EshopCatalog\FrontModule\Model\Dao\Product;
use EshopCatalog\FrontModule\Model\ProductsFacade;
use Nette\Application\UI\Multiplier;

class VariantsPopup extends BaseControl
{
	/** @var ?Product */
	protected $product = null;

	protected ICartAddFormFactory $cartAddFormFactory;
	protected ProductsFacade      $productsFacade;

	public function __construct(
		?Product            $product,
		ProductsFacade      $productsFacade,
		ICartAddFormFactory $cartAddFormFactory
	)
	{
		$this->product            = $product;
		$this->productsFacade     = $productsFacade;
		$this->cartAddFormFactory = $cartAddFormFactory;
	}

	public function render(): void
	{
		if (!$this->product) {
			return;
		}

		$this->template->product = $this->product;
		$this->template->render($this->getTemplateFile());
	}

	public function handleShowPopup(): void
	{
		$this->template->showModal = true;
		$this->redrawControl('modal');
	}

	public function handleSelectVariant(): void
	{
		$this->product = $this->productsFacade->getProduct((int) $this->getParameter('variant'));

		$this->template->product   = $this->product;
		$this->template->showModal = true;
		$this->redrawControl('modal');
	}

	protected function createComponentCartAddForm(): Multiplier
	{
		return new Multiplier(function($productId): CartAddForm {
			$control = $this->cartAddFormFactory->create();
			$control->setProduct($this->product->variants[$productId]);

			return $control;
		});
	}
}
