<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;

/**
 * @ORM\Entity
 * @ORM\Table(name="eshop_catalog__related_product")
 */
class RelatedProduct
{
	use TId;

	/**
	 * @var Product
	 * @ORM\ManyToOne(targetEntity="Product", inversedBy="relatedProducts")
	 * @ORM\JoinColumn(name="origin_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	protected Product $origin;

	/**
	 * @var Product
	 * @ORM\ManyToOne(targetEntity="Product")
	 * @ORM\JoinColumn(name="product_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	protected Product $product;

	/**
	 * @var RelatedGroup
	 * @ORM\ManyToOne(targetEntity="RelatedGroup")
	 * @ORM\JoinColumn(name="group_id", referencedColumnName="id", nullable=false, onDelete="CASCADE")
	 */
	protected RelatedGroup $group;

	public function __construct(Product $origin, Product $product, RelatedGroup $group)
	{
		$this->origin  = $origin;
		$this->product = $product;
		$this->group   = $group;
	}

	/**
	 * @return Product
	 */
	public function getOrigin(): Product { return $this->origin; }

	/**
	 * @return Product
	 */
	public function getProduct(): Product { return $this->product; }

	/**
	 * @return RelatedGroup
	 */
	public function getGroup(): RelatedGroup { return $this->group; }

	public function setGroup(RelatedGroup $group): void { $this->group = $group; }
}
