<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Doctrine;
use Doctrine\ORM\Event\LifecycleEventArgs;
use Doctrine\ORM\Mapping as ORM;
use EshopCatalog\FrontModule\Model\CacheService;
use EshopCatalog\Model\Helpers\VariantsHelper;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Nette\Caching\Cache;
use Nette\SmartObject;

class CategoryProductListener implements EventSubscriberInterface
{
	use SmartObject;

	protected static array $created = [];

	protected CacheService $cacheService;

	protected VariantsHelper $variantsHelper;

	public function __construct(CacheService $cacheService, VariantsHelper $variantsHelper)
	{
		$this->cacheService   = $cacheService;
		$this->variantsHelper = $variantsHelper;
	}

	public static function getSubscribedEvents(): array
	{
		return [];
	}

	/**
	 * @ORM\PostUpdate
	 *
	 * @param CategoryProduct    $categoryProduct
	 * @param LifecycleEventArgs $event
	 *
	 * @throws Doctrine\ORM\ORMException
	 */
	public function postUpdate(CategoryProduct $categoryProduct, LifecycleEventArgs $event)
	{
	}

	/**
	 * @ORM\PostRemove
	 *
	 * @param CategoryProduct    $categoryProduct
	 * @param LifecycleEventArgs $event
	 *
	 * @throws Doctrine\ORM\ORMException
	 */
	public function postRemove(CategoryProduct $categoryProduct, LifecycleEventArgs $event)
	{
		// In category container
	}

	/**
	 * @ORM\PreFlush
	 *
	 * @param CategoryProduct    $categoryProduct
	 * @param LifecycleEventArgs $args
	 */
	public function onPreFlush($categoryProduct, $args)
	{
		$em = $args->getEntityManager();
		foreach ($em->getUnitOfWork()->getScheduledEntityInsertions() as $entity) {
			if ($entity instanceof CategoryProduct === false || $entity->getIdProduct() === null)
				continue;

			$key = $entity->getIdProduct() . '-' . $entity->getIdCategory();
			if (isset(self::$created[$key]))
				continue;
			self::$created[$key] = true;

			foreach ($this->variantsHelper->getProductVariants($entity->getIdProduct()) as $prodId) {
				try {
					$em->getConnection()->insert('eshop_catalog__category_product', [
						'id_product'  => $prodId,
						'id_category' => $entity->getIdCategory(),
					]);
				} catch (\Exception $e) {
				}
			}
		}
	}
}
