<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Helpers;

use Core\Model\Dao\Site;
use Core\Model\Sites;
use Core\Model\Settings;
use Users\Model\Entities\User;

class Helper
{
	protected Settings $settings;

	protected Sites $sites;

	public function __construct(Settings $settings, Sites $sites)
	{
		$this->settings = $settings;
		$this->sites    = $sites;
	}

	public function getRegisterUserSale(User $user, ?Site $site = null): float
	{
		if (!$site)
			$site = $this->sites->getCurrentSite();

		$disabledRegisterUserSale = (array) $this->settings->get('eshopCatalogDisableRegisterUserSaleForRole', []);
		foreach ($user->getRolesId() as $roleId) {
			if (in_array($roleId, $disabledRegisterUserSale)) {
				return 0;
			}
		}

		return (float) $this->settings->get('eshopCatalog' . ucfirst($site->getIdent()) . 'RegisterUserSale', 0);
	}
}
