import {Fancybox, Carousel} from "@fancyapps/ui";

Fancybox.bind('[data-fancybox="product"]', {
	caption: function (fancybox, carousel, slide) {
		return (
			(slide.imageTitle ? `<div><b>${slide.imageTitle}</b></div>` : '')
			+ (slide.imageDescription ? `${slide.imageDescription}` : '')
		);
	},
});

const mainCarousel = new Carousel(document.querySelector(".product-intro__slider--fancybox"), {
	slidesPerPage: 1,
	Dots         : false,
	Navigation   : false,
	infinite     : false,
	center       : true,
});


const previewCarousel = new Carousel(document.querySelector(".product-intro__slider-previews-wrapper--fancybox .product-intro__previews"), {
	slidesPerPage: 4,
	Dots         : false,
	Navigation   : true,
	infinite     : false,
	center       : false,
});
document.addEventListener('click', e => {
	if (e.target.classList.contains('product-intro__slider-previews__item')) {
		previewCarousel.slideTo(e.target.dataset.index);
	}
});
