import {tns} from "tiny-slider/src/tiny-slider";

document.addEventListener('DOMContentLoaded', () => {

	/**
	 * Úvodní obrázek slider
	 */
	const productSlider = document.getElementById('product-slider') || null;
	if (productSlider && !productSlider.classList.contains('product-intro__slider--fancybox')) {
		const slider = tns({
			container           : productSlider,
			items               : 1,
			controls            : false,
			autoplayButtonOutput: false,
			nav                 : false,
			mouseDrag           : true
		});

		const previews = document.querySelectorAll('.product-intro__preview');
		previews.forEach((el) => {
			el.addEventListener('click', () => {
				const id = el.dataset.slideId;
				slider.goTo(id);
			});
		});
	}


	/**
	 * Produkt slider
	 */
	const previewContainers = document.querySelectorAll('.product-intro__slider-previews');
	previewContainers.forEach((el) => {
		if (el.classList.contains('product-intro__slider--fancybox')) {
			return;
		}

		const wrapper       = el.closest('.product-intro__slider-previews-wrapper')
		const previewSlider = tns({
			container           : el,
			loop                : false,
			items               : 4,
			controls            : false,
			mouseDrag           : true,
			autoplayButtonOutput: false,
			nav                 : false
		})
		if (wrapper) {
			const btnPrev = wrapper.querySelector('[data-controls=prev]');
			const btnNext = wrapper.querySelector('[data-controls=next]');
			if (btnPrev) {
				btnPrev.addEventListener('click', () => {
					previewSlider.goTo('prev')
				})
			}
			if (btnNext) {
				btnNext.addEventListener('click', () => {
					previewSlider.goTo('next')
				})
			}
		}
	})
});
