<?php declare(strict_types = 1);

namespace EshopCatalog\AdminModule\Components\ImportExport;

use Core\Model\Http\CsvResponse;
use Core\Model\UI\BaseControl;
use EshopCatalog\Model\Config;
use Nette\Http\Request;
use Nette\Utils\DateTime;

class DuplicatedProductData extends BaseControl
{
	protected Request $request;

	public function __construct(
		Request $request
	)
	{
		$this->request = $request;
	}

	public function render(): void
	{
		$this->template->render($this->getTemplateFile());
	}

	public function handleExportName()
	{
		CsvResponse::sendResponse(
			$this->t('eshopCatalog.duplicatedProductData.nameFilename') . ' ' . (new DateTime())->format('Y-m-d H-i') . '.csv',
			$this->prepareCsv('name'),
		);
	}

	public function handleExportAlias()
	{
		if (!Config::load('product.allowModifyAlias')) {
			$this->getPresenter()->error();
		}

		CsvResponse::sendResponse(
			$this->t('eshopCatalog.duplicatedProductData.aliasFilename') . ' ' . (new DateTime())->format('Y-m-d H-i') . '.csv',
			$this->prepareCsv('alias'),
		);
	}

	protected function prepareCsv(string $column): ?string
	{
		$url = $this->request->getUrl()->getBaseUrl();

		$fp = fopen('php://memory', 'wb+');

		fputcsv($fp, [
			$this->t('eshopCatalog.duplicatedProductData.lang'),
			$this->t('eshopCatalog.duplicatedProductData.' . $column),
			$this->t('eshopCatalog.duplicatedProductData.code1'),
			$this->t('eshopCatalog.duplicatedProductData.id'),
			$this->t('eshopCatalog.duplicatedProductData.adminLink'),
		], ',');

		foreach ($this->em->getConnection()->executeQuery("
			SELECT GROUP_CONCAT(pt.id) as ids, pt.{$column}, GROUP_CONCAT(p.code1) as codes, pt.lang, COUNT(*)
			FROM eshop_catalog__product_texts pt
			INNER JOIN eshop_catalog__product p ON pt.id = p.id
			GROUP BY pt.lang, pt.{$column}
			HAVING COUNT(*) > 1
			")->fetchAllAssociative() as $row) {
			if (!$row[$column]) {
				continue;
			}

			$ids = explode(',', (string) $row['ids']);
			$codes = explode(',', (string) $row['codes']);

			$id = array_shift($ids);
			fputcsv($fp, [
				$row['lang'],
				$row[$column],
				array_shift($codes),
				$id,
				$url . 'admin/eshop-catalog/products/edit/' . $id,
			], ',');

			while (!empty($ids)) {
				$id = array_shift($ids);
				fputcsv($fp, [
					'',
					'',
					array_shift($codes),
					$id,
					$url . 'admin/eshop-catalog/products/edit/' . $id,
				], ',');
			}
		}

		rewind($fp);
		$output = stream_get_contents($fp);

		fclose($fp);

		return $output;
	}
}
