<?php declare(strict_types = 1);

namespace EshopCatalog\Model\Entities;

use Core\Model\Entities\TTranslateListener;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\ORM\Mapping as ORM;
use Gedmo\Mapping\Annotation as Gedmo;
use Core\Model\Entities\TId;

/**
 * @ORM\Table(name="eshop_catalog__related_group")
 * @ORM\Entity
 * @ORM\EntityListeners({"Core\Model\Entities\TranslateListener"})
 */
class RelatedGroup
{
	use TId;
	use TTranslateListener;

	/**
	 * @var int
	 * @ORM\Column(name="is_published", type="smallint", options={"default": 1})
	 */
	public int $isPublished = 1;

	/**
	 * @var int
	 * @Gedmo\SortablePosition
	 * @ORM\Column(name="position", type="integer")
	 */
	protected int $position = -1;

	/**
	 * @var RelatedGroupText[]
	 * @ORM\OneToMany(targetEntity="RelatedGroupText", mappedBy="group", indexBy="lang", cascade={"persist", "remove"})
	 */
	protected $texts;

	public function __construct()
	{
		$this->texts = new ArrayCollection();

		$this->setPosition(-1);
	}

	/**
	 * @return int
	 */
	public function getPosition(): int { return $this->position; }

	/**
	 * @param int $position
	 *
	 * @return $this
	 */
	public function setPosition(int $position)
	{
		$this->position = $position;

		return $this;
	}

	/**
	 * @param string|null $lang
	 *
	 * @return RelatedGroupText|mixed
	 */
	public function getText(?string $lang = null)
	{
		return $this->texts[$lang ?: $this->locale];
	}

	/**
	 * @return ArrayCollection|RelatedGroupText[]
	 */
	public function getTexts() { return $this->texts; }

	/**
	 * @param array $texts
	 *
	 * @return $this
	 */
	public function setTexts(array $texts): self
	{
		$this->texts = new ArrayCollection($texts);

		return $this;
	}
}
