<?php declare(strict_types = 1);

namespace EshopCatalog\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\Templating\Macros\TemplateText;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use EshopCatalog\FrontModule\Model\Features;
use Nette\Localization\ITranslator;

class FeatureValues extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'eshopCatalogTagValues';

	/** @var Features */
	protected $featuresService;

	/** @var ITranslator */
	protected $translator;

	public function __construct(Features $features, ITranslator $translator)
	{
		$this->featuresService = $features;
		$this->translator      = $translator;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 * @param array         $texts
	 */
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		if (!isset($params['tag'])) {
			$features = $this->featuresService->getPublishedFeatures();

			$formContainer->addSelect($this->getName(), $this->getTitle(), $features);
		}
	}

	public function render($params)
	{
		$featureId = isset($params['tag']) ? (int) $params['tag'] : (int) $this->getDefault();

		if (!isset($params['toVar']))
			throw new InvalidArgumentException('Need variable for output');

		$feature = $this->featuresService->getFeatureById($featureId);

		return $feature ? [
			'id'     => $feature['id'],
			'name'   => $feature['name'],
			'values' => $this->featuresService->getValuesByFeatureId($featureId),
		] : null;
	}
}
