<?php declare(strict_types = 1);

namespace EshopCatalog\Model\TemplateTextType;

use Contributte\Latte\Exception\Logical\InvalidArgumentException;
use Core\Model\UI\Form\BaseContainer;
use Core\Model\TemplateReader\Providers\ITemplateTextType;
use Core\Model\TemplateReader\Providers\TemplateTextType;
use EshopCatalog\AdminModule\Model\Categories as AdminCategories;
use EshopCatalog\FrontModule\Model\Categories as FrontCategories;
use EshopCatalog\FrontModule\Model\Products;
use EshopCatalog\FrontModule\Model\ProductsFacade;
use Nette\Localization\ITranslator;
use Nette\Localization\Translator;

class SelectedCategories extends TemplateTextType implements ITemplateTextType
{
	/** @var string */
	protected $type = 'eshopCatalogSelectedCategories';

	protected FrontCategories $frontCategories;

	protected AdminCategories $adminCategories;

	protected Translator $translator;

	public function __construct(FrontCategories $frontCategories, AdminCategories $adminCategories, Translator $translator)
	{
		$this->frontCategories = $frontCategories;
		$this->adminCategories = $adminCategories;
		$this->translator      = $translator;
	}

	/**
	 * @param BaseContainer $formContainer
	 * @param array         $params
	 * @param array         $texts
	 */
	public function loadContainer($formContainer, $params = [], $texts = [])
	{
		$formContainer->addCheckboxNestedList($this->getName(), $this->getTitle(), $this->adminCategories->getFlatTree());
	}

	public function render($params)
	{
		$default = $this->getDefault();

		if (!$default || !is_array($default))
			return [];

		if (!isset($params['toVar'])) {
			bdump('Need variable for output');

			return [];
		}

		$categories = [];
		foreach ($default as $id)
			$categories[(int) $id] = $this->frontCategories->get((int) $id);

		return $categories;
	}
}
