<?php declare(strict_types = 1);

namespace EshopCheckout\AdminModule\Presenters;

use Nette\Application\BadRequestException;
use Nette\Application\ForbiddenRequestException;
use Objects\Model\Repository\Objects;

/**
 * Class BasePresenter
 * @package EshopCheckout\AdminModule\Presenters
 */
abstract class BasePresenter extends \Core\AdminModule\Presenters\BasePresenter
{

	/**
	 * @param $element
	 */
	public function checkRequirements($element): void
	{
		parent::checkRequirements($element);

		if (!$this->getUser()->isAllowed($this->getFullModuleName(), 'access')) {
			$this->error();
		}

	}
}
